VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Sub Command1_Click()
   Call pdf.CreateNewPDF(vbNullString) ' The ouput file is opened later

   Dim outFile As String
   outFile = App.Path & "\out.pdf"

   ' We assume that the pdf invoice is already a valid PDF/A 3 file in this example.

   Call pdf.SetImportFlags(TImportFlags.ifImportAsPage Or TImportFlags.ifImportAll)
   Call pdf.OpenImportFile("../../../test_files/test_invoice.pdf", TPwdType.ptOpen, "")

   Call pdf.ImportPDFFile(1, 1#, 1#)

   Dim ef As Long
   ef = pdf.AttachFile("../../../test_files/factur-x.xml", "EN 16931 compliant invoice", False)
   Call pdf.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)

   'Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
   'the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
   'compliant and hence cannot be used to create e-invoices.
   Call pdf.SetPDFVersion(TPDFVersion.pvFacturX_Comfort)

   ' No fatal error occurred?
   If pdf.HaveOpenDoc() Then
      ' OK, now we can open the output file.
      If Not pdf.OpenOutputFile(outFile) Then Return
      If pdf.CloseFile() Then
         ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   ' Set the license key here if you have one
   ' Call pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' External cmaps should be loaded if possible.
   Call pdf.SetCMapDir(GetFullPath("../../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
